import { Link } from "react-router-dom";
import React, { useState, FormEventHandler } from "react";

interface login {
  id: string;
  password: string;
}

// const fake = { id: "asdf", password: "qwer" };

function Logindata() {
  const [id, setId] = useState("");
  const [password, setPassword] = useState("");

  function login() {
    fetch(`http://localhost:3000/api/auth/login`, {
      method: "POST",

      body: JSON.stringify({
        email: `${id}`,
        password: `${password}`,
      }),
    }).then((response) => {
      console.log(response.json());
    });
  }
  return (
    <div className="flex flex-col md:w-2/3 md:gap-2">
      <input
        className="placeholder:text-slate-300
                bg-white border border-slate-500 rounded-2xl
                py-2 pl-9 pr-3 
                focus:border-black
                "
        placeholder="Id"
        type="text"
        name="Id"
        onChange={(e) => setId(e.target.value)}
      />
      <input
        className="placeholder:italic placeholder:text-slate-300
                bg-white border border-slate-500 rounded-2xl
                py-2 pl-9 pr-3 
                focus:border-black
                "
        placeholder="Password"
        type="password"
        name="Password"
        onChange={(e) => setPassword(e.target.value)}
      />

      <button
        type="submit"
        className="md:w-1/3 bg-sky-600 hover:bg-sky-700 rounded-xl"
        onClick={login}
      >
        <Link to={"/"}>login</Link>
      </button>
    </div>
  );
}

export default function Login() {
  return (
    <div>
      {/* <form onSubmit={loginsubmit}> */}
      <div className="flex flex-row grid grid-rows-2">
        <div className=" p-12 w-1/2 h-1/2 md:w-40 md:h-40 bg-red-400 place-self-center rounded-2xl">
          <Link to="/">Travel Report</Link>
        </div>

        <div className=" flex-row w-auto h-60 md:w-1/2 bg-white border-2 border-black grid place-items-center rounded-xl place-self-center">
          <div className="flex flex-col w-full  md:flex-row md:p-20 md:gap-10">
            <Logindata />
          </div>
          <div className="flex-row grid grid-cols-3">
            <button className="bg-white bottom-0 right-0">
              <Link to="/signup">회원가입</Link>
            </button>
            <div></div>
            <button className="bg-white inset-x-0">
              <Link to="/forgot">비밀번호 찾기</Link>
            </button>
          </div>
        </div>
      </div>
      {/* </form> */}
    </div> // Login Page
  );
}
