import React, { useState } from "react";
import Theme from "./theme";
import { PostType } from "./typesrc";
import axios from "axios";

function Title() {
  const [title, setTitle] = useState<string>("질문종류");

  function TitleChange(e: { target: { value: React.SetStateAction<string> } }) {
    setTitle(e.target.value);
  }
}

function Body() {
  const [body, setBody] = useState<string>("질문종류");

  function BodyChange(e: { target: { value: React.SetStateAction<string> } }) {
    setBody(e.target.value);
  }
}

function SelectCity() {
  const [selectCity, setSelectCity] = useState<string>("질문종류");

  function CityChange(e: { target: { value: React.SetStateAction<string> } }) {
    setSelectCity(e.target.value);
  }
  return (
    <select
      id="Questions"
      className="border border-3 border-black w-1/12"
      onChange={CityChange}
      defaultValue="질문종류"
    >
      <option value="질문종류">도시</option>
      <option value="Seoul">서울</option>
      <option value="Busan">부산</option>
      <option value="Incheon">인천</option>
      <option value="Daegoo">대구</option>
      <option value="Kwangjoo">광주</option>
      <option value="Daejeon">대전</option>
      <option value="Woolsan">울산</option>
      <option value="Sejong">세종</option>
      <option value="Dokdo">독도</option>
      <option value="Jeju">제주</option>
    </select>
  );
}

function SelectTheme() {
  const [selectTheme, setSelectTheme] = useState<string>("질문종류");

  function ThemeChange(e: { target: { value: React.SetStateAction<string> } }) {
    setSelectTheme(e.target.value);
  }
  return (
    <select
      id="Questions"
      className="border border-3 border-black w-1/12"
      onChange={ThemeChange}
      defaultValue="질문종류"
    >
      <option value="질문종류">테마</option>
      <option value="cycling">사이클링</option>
      <option value="surfing">서핑</option>
      <option value="activity">액티비티</option>
      <option value="camping">캠핑</option>
      <option value="sking">스키</option>
      <option value="boat">보트</option>
      <option value="desert">사막</option>
      <option value="golf">골프</option>
      <option value="cave">동굴</option>
      <option value="history">문화재</option>
      <option value="zoo">동물원</option>
      <option value="cycling">사이클링</option>
      <option value="cycling">{selectTheme}</option>
    </select>
  );
}
// 눌렀다는 데이터가 어딘가에 있어야 한다. Map 객체를 이용해서 기타등등

// function postup() {
//   axios.post("localhost:3000/api/post/up", {
//     id: "a",
//     title: title,
//     body: body,
//     date: `${() => new Date()}`,
//     theme: selectTheme,
//     city: selectCity,
//   });
// }

export default function Posting() {
  return (
    <div className="flex flex-col border-3">
      <form className="w-full items-center">
        <div className="flex flex-row relative">
          <p className="basis-1/12 gap-x-8">Id</p>
          <p className="basis-8/12 invisible">empty</p>
          <SelectCity />
          <SelectTheme />

          <button
            type="submit"
            className="border border-black basis-1/12 gap-x-8"
          >
            글쓰기
          </button>
        </div>

        <div className="flex border-4">
          <textarea
            onChange={Title}
            placeholder="title"
            className="w-full h-8"
          ></textarea>
        </div>
        <div onChange={Body} className="flex border-2">
          <textarea placeholder="body" className="w-full h-96"></textarea>
        </div>
      </form>
    </div>
  );
}
