import React, { useEffect, MouseEvent, useState, useRef } from "react";
import { Outlet, useSearchParams } from "react-router-dom";
import Theme from "./theme";
import Citylist from "../Pages/citylist";
import { getPicure } from "../Pages/pic";
// import { Pagination} from "../Pages/picpagination";

const initSearchParams = { theme: "", city: "" };

export default function Body() {
  let limit = 15;
  const [searchParams, setSearchParams] = useSearchParams(initSearchParams);
  const [page, setPage] = useState(1);
  const [style, setStyle] = useState("");
  const firstRightClick = useRef(true);
  const firstLeftClick = useRef(true);
  const slide = useRef(1);
  const offset1 = (page - 1) * limit;
  const offset2 = page * limit;
  const offset3 = (page + 1) * limit;

  let getPics = getPicure();
  
  useEffect(() => {
    console.log(searchParams.get("theme"), searchParams.get("city"));
    setSearchParams(searchParams)
  }, []);

  const themeHandleClick = (event: MouseEvent<HTMLButtonElement>) => {
    console.log(`theme id= ${event.currentTarget.id}`);
    setSearchParams({
      ...Object.fromEntries(searchParams),
      theme: event.currentTarget.id,
    });
  };

  const cityHandleClick = (event: MouseEvent<HTMLButtonElement>) => {
    console.log(`city id= ${event.currentTarget.id}`);
    setSearchParams({
      ...Object.fromEntries(searchParams),
      city: event.currentTarget.id,
    });
  };
  
  const leftClick = () => {
    if (firstLeftClick.current) {
      firstLeftClick.current = false;
      firstRightClick.current = true;
    } else {
      setPage(page - 1)
    }
    slide.current -= 1;
    setStyle("-translate-x-full animate-slidetoright");
  };
  
  const rightClick = () => {
    if (firstRightClick.current) {
      firstLeftClick.current = true;
      firstRightClick.current = false;
    } else {
      setPage(page + 1)
    }
    slide.current += 1;
    setStyle("animate-slidetoleft");
  };
  console.log(`page: ${slide.current}`);
  console.log(`style: ${style}`);
  
  let themechange = searchParams.get("theme");
  let citylistchange = searchParams.get("city");
  
  const Idpics = getPics.filter((p) => {
    return (
      (p.themeid == themechange && p.cityid == citylistchange) ||
      (p.themeid == themechange && citylistchange == "") ||
      (themechange == "" && p.cityid == citylistchange) ||
      (themechange == "" && citylistchange == "")
      );
    });

    const numPages = Math.ceil(Idpics.length / 15);
    
    return (
    <div className="flex flex-col px-1 py-1">
      <Theme handleClick={themeHandleClick} />
      <div className="flex flex-col md:flex-row py-10 ">
        <div className="w-50">
          <Citylist handleClick={cityHandleClick} />
        </div>
        <div className="flex flex-col  overflow-hidden">
          <div>
            <button onClick={leftClick} disabled={slide.current === 1}>
              &lt;{slide.current}
            </button>
            <button onClick={rightClick} disabled={slide.current === numPages}>
              &gt;
            </button>
          </div>
          <div className={`md:mr-10 md:basis-4/5 flex flex-row relative w-full `}>  
            <div key={Math.random()} className="min-w-full">
              <div  className={`inline-grid grid-cols-5 ${style}`}>
                {Idpics.slice(offset1, offset1 + limit).map((pic, index: number) => (
                  <div
                    className={`m-1 shrink-0 bg-gray-200 rounded shadow-md `}
                    key={index}>
                    <img
                      src={pic.url}
                      className="w-full h-10 md:h-20 object-center"
                    />
                    <p className="text-center text-xs">{pic.name}</p>
                  </div>
                ))}
              </div>
            </div>
            <div key={Math.random()} className="min-w-full">
              <div className={`inline-grid grid-cols-5 ${style}`}>
                {Idpics.slice(offset2, offset2 + limit).map((pic, index: number) => (

                  <div
                    className={`m-1 shrink-0 bg-gray-200 rounded shadow-md `}
                    key={index}
                  >
                    <img
                      src={pic.url}
                      className="w-full h-10 md:h-20 object-center"
                    />
                    <p className="text-center text-xs">{pic.name}</p>
                  </div>
                ))}
              </div>
            </div>
            <div key={Math.random()} className="min-w-full">
              <div className={`inline-grid grid-cols-5 ${style}`}>
                {Idpics.slice(offset3, offset3 + limit).map((pic, index: number) => (

                  <div
                    className={`m-1 shrink-0 bg-gray-200 rounded shadow-md `}
                    key={index}
                  >
                    <img
                      src={pic.url}
                      className="w-full h-10 md:h-20 object-center"
                    />
                    <p className="text-center text-xs">{pic.name}</p>
                  </div>
                ))}
              </div>
            </div>
          </div>
        </div>
      </div>

      <Outlet />
    </div>
    // Body Page
  );
}

