import express from "express";
import { mainimgCtrl, authCtrl } from "../controllers";

const router = express.Router();

router
  .route("/")
  .get( mainimgCtrl.getMainimg)
  .post(authCtrl.requireLogin,authCtrl.hasRole("admin"), mainimgCtrl.createMainimg)
  
router
  .route("/:imgId")
  .delete(authCtrl.requireLogin,authCtrl.hasRole("admin"), mainimgCtrl.deleteMainimg)
  .put(authCtrl.requireLogin,authCtrl.hasRole("admin"), mainimgCtrl.updateMainimg);


export default router;
