import { NextFunction, Request, Response } from "express";
import isLength from "validator/lib/isLength";
import { TypedRequestAuth } from "./auth.controller";
import { asyncWrap } from "../helpers";
import { mainimgDb } from "../db";
import { TypedRequest } from "../types";

export const createMainimg = asyncWrap(async (reqExp, res, next) => {
  const req = reqExp as TypedRequestAuth<{ userId: string }>;

  const { theme, city, url, title } = req.body as {
    theme: string;
    city: string;
    url: string;
    title: string;
  };

  console.log("body", req.body);

  if (!isLength(url ?? "", { min: 1 })) {
    return res.status(422).send("이미지 url을 입력해주세요");
  }

  if (!isLength(title ?? "", { min: 1 })) {
    return res.status(422).send("이미지 제목을 입력해주세요");
  }

  const newMainimg = await mainimgDb.createMainimg({
    theme,
    city,
    url,
    title,
  });

  return res.json(newMainimg);
});

export const getMainimg = asyncWrap(async (req, res) => {
  const mainimgs = await mainimgDb.getMainimg();
  return res.json(mainimgs);
});


export const deleteMainimg = asyncWrap(async (req, res) => {
  const { imgId } = req.params;
  console.log(imgId);
  const deleteCount = await mainimgDb.deleteOneMainimg(imgId);

  return res.json(deleteCount);
});



