import { NextFunction, Request, Response } from "express";
import isLength from "validator/lib/isLength";
import equals from "validator/lib/equals";
import { asyncWrap } from "../helpers";

export const posting = asyncWrap(async (req, res) => {
  const { title, text, date, theme, city } = req.body;

  console.log("body", req.body);

  // 1) title 빈 문자열인지 확인
  if (!isLength(title ?? "", { min: 1 })) {
    return res.status(422).send("제목을 한 글자 이상 입력해주세요");
  }

  // 2) body 빈 문자열인지 확인
  if (!isLength(text ?? "", { min: 1 })) {
    return res.status(422).send("제목을 한 글자 이상 입력해주세요");
  }

  // 3) submit 이벤트 발생시 date값 입력

  // 4) theme dropdown default-value "테마"일 경우 에러
  if (equals(theme, "질문종류")) {
    return res.status(422).send("테마를 입력해 주세요");
  }

  // 5) city dropdown default-value "도시"일 경우 에러
  if (equals(city, "질문종류")) {
    return res.status(422).send("도시를 선택해 주세요");
  }
});
