import { model, Schema } from "mongoose";

export interface PostingType {
  title: string;
  text?: string;
  theme: string;
  city: string;
  username?: string;
}

const postingSchema = new Schema<PostingType>(
  {
    title: {
      type: String,
      required: true,
      unique: true,
    },
    text: {
      type: String,
      required: true,
      unique: true,
    },
    theme: {
      type: String,
      unique: true,
    },
    city: {
      type: String,
      unique: true,
    },
    // username: {
    //   type: String,
    //   unique: true,
    // },
  } // username 때문에 duplicate key error 발생
);

export default model<PostingType>("Posting", postingSchema);
