import express from "express";
import { postCtrl, authCtrl } from "../controllers";

const router = express.Router();

router.route("/").post(authCtrl.requireLogin, postCtrl.createFileAndPost);
router.route("/").get(postCtrl.getAllPost);

router.route("/files/:postId").get(authCtrl.requireLogin, postCtrl.getFiles);

router
  .route("/:postId")
  .post(authCtrl.requireLogin, postCtrl.addCounts)
  .delete(authCtrl.requireLogin, authCtrl.authenticate, postCtrl.deleteOnePost)
  .put(authCtrl.requireLogin, authCtrl.authenticate, postCtrl.updateOnePost);

router.param("postId", postCtrl.userByPostId);
export default router;
