import express from "express";
import { postCtrl, authCtrl } from "../controllers";

const router = express.Router();

router.route("/").post(authCtrl.requireLogin, postCtrl.postCreate);
router.route("/").get(postCtrl.getAllPost);

router
  .route("/:postId")
  .post(authCtrl.requireLogin, postCtrl.addCounts)
  .get(authCtrl.requireLogin, postCtrl.getOnePost);

router.route("/:postId").delete(authCtrl.requireLogin, postCtrl.deleteOnePost); // authenticate

router.route("/:postId").put(authCtrl.requireLogin, postCtrl.updatePost);

router.param("postId", postCtrl.userByPostId);
export default router;
