import { Post, PostType } from "../models";

export const createPost = async (post: PostType) => {
  const newPosting = await Post.create({
    title: post.title,
    text: post.text,
    theme: post.theme,
    city: post.city,
    user: post.user,
    date: post.date,
    counts: 0,
  });
  return newPosting;
};

export const getPosts = async () => {
  const posts = await Post.find({});
  return posts;
};

export const addOneCount = async (_id: string, counts: number) => {
  const newCounts = await Post.findOneAndUpdate(
    { _id: _id },
    { counts: counts },
    { new: true }
  );
  // console.log(newCounts);

  return newCounts;
};

export const getPost = async (_id: string) => {
  const post = await Post.findOne({ _id: _id });
  return post;
};

export const deletePost = async (_id: string) => {
  const res = await Post.deleteOne({ _id: _id });
  return res;
};

export const updateOnePost = async (post: PostType, _id: string) => {
  const newPost = await Post.findOneAndUpdate(
    { _id: _id },
    { post },
    { new: true }
  );
  return newPost;
};
