import { ObjectId } from "mongoose";
import { FileInfo, IFileInfo, Mainimg, MainimgType } from "../models";
import fs from "fs/promises";
import { fileInfoCtrl } from "../controllers";

export const createMainimg = async (mainimg: MainimgType, pic: IFileInfo) => {
  const newPic = await FileInfo.create({
    originalfilename: pic.originalfilename,
    newfilename: pic.newfilename,
    pictureauth: pic.picturepath,
  });

  const newMainimg = await Mainimg.create({
    theme: mainimg.theme,
    city: mainimg.city,
    fileInfo: newPic._id,
    title: mainimg.title,
  });
  return newMainimg.populate("fileInfo");
};

export const getMainimg = async () => {
  const img = await Mainimg.find({}).populate("fileInfo");

  return img;
};

export const deleteOneMainimg = async (_id: string) => {
  const main = await Mainimg.findById(_id);
  if (!(main?.fileInfo === undefined)) {
    const ref = await FileInfo.findById(main.fileInfo._id);
    if (!(ref?.newfilename === undefined)) {
      await fs.unlink("../travel/uploads/" + ref?.newfilename);
    }
    await FileInfo.deleteOne({ _id: main.fileInfo._id });
    const res = await Mainimg.deleteOne({ _id: _id });
    return res;
  }
};

export const updateOneMainimg = async (
  _Id: string,
  theme: string,
  city: string,
  title: string,
  originalfilename?: string | null,
  newfilename?: string
) => {
  const newMainimg = await Mainimg.findById(_Id);
  console.log("error2", _Id);
  if (!(newMainimg?.fileInfo === undefined)) {
    if (originalfilename === undefined) {
      await Mainimg.findByIdAndUpdate(newMainimg._id, {
        theme: theme,
        city: city,
        title: title,
      });
      console.log("errrror4");
    } else if (
      !(originalfilename === undefined) &&
      (!(theme === undefined) ||
        !(city === undefined) ||
        !(title === undefined))
    ) {
      await Mainimg.findByIdAndUpdate(newMainimg._id, {
        theme: theme,
        city: city,
        title: title,
      });
      await FileInfo.findByIdAndUpdate(newMainimg.fileInfo._id, {
        originalfilename: originalfilename,
        newfilename: newfilename,
      });
      console.log("error6");
    } else {
      await FileInfo.findByIdAndUpdate(newMainimg.fileInfo._id, {
        originalfilename: originalfilename,
        newfilename: newfilename,
      });
      console.log("error5", newfilename, originalfilename, theme, city, title);
    }
  } else console.log("error3", newMainimg);
};
