import axios from "axios";
import baseUrl from "./baseUrl";
import { PostType } from "../types";

//Create
export const createFileAndPost = async (formdata: FormData) => {
  const { data } = await axios.post(`${baseUrl}/posts/`, formdata);
  return data;
};

//Read
export const getData = async () => {
  const { data } = await axios.get(`${baseUrl}/posts/`);
  return data;
};

export const getFileByPostId = async (postId: string) => {
  const { data } = await axios.get(`${baseUrl}/posts/files/${postId}`);
  return data;
};

//Update
export const addCounts = async (postId: string, counts: number) => {
  const { data } = await axios.post(`${baseUrl}/posts/${postId}`, {
    counts: counts + 1,
  });
  return data;
};

export const updateImgAndPost = async (postId: string, formdata: FormData) => {
  const { data } = await axios.put(`${baseUrl}/posts/${postId}`, formdata);
  return data;
};

//Delete
export const deletePost = async (postId: string) => {
  const { data } = await axios.delete(`${baseUrl}/posts/${postId}`);
  return data;
};
