import React from "react";
import { BrowserRouter, Route, Routes } from "react-router-dom";
import "tailwindcss/tailwind.css";
import { IntoPost } from "./post/intopost";
import { Login, Profile, RequireAuth, Signup, Admin, ImgRewrite } from "./auth";
import { Header, Body } from "./home";
import { Board } from "./board";
import Posting from "./post/posting";
import { Layout } from "./commons";
import { EditPost } from "./post/editpost";

export const App = () => {
  return (
    <BrowserRouter>
      <Routes>
        <Route element={<Layout />}>
          <Route path="/" element={<Header />}>
            <Route path="login" element={<Login />} />
            <Route path="signup" element={<Signup />} />
            <Route index element={<Body />} />
            <Route
              path="posting"
              element={
                <RequireAuth>
                  <Posting />
                </RequireAuth>
              }
            />
            <Route path="board" element={<Board />} />
            <Route path="post/:postId" element={<IntoPost />} />
            <Route path="edit" element={<EditPost />} />
            <Route
              path="profile"
              element={
                <RequireAuth>
                  <Profile />
                </RequireAuth>
              }
            />
            <Route path="admin" element={<RequireAuth><Admin /></RequireAuth>} />
            <Route path="admin/:imgId" element={<ImgRewrite />} />
            <Route path="rewrite" element={<ImgRewrite />} />
          </Route>
        </Route>
      </Routes>
    </BrowserRouter>
  );
};
