import { NextFunction, Request, Response } from "express";
import formidable, { Fields, Files } from "formidable";
import { TypedRequestAuth } from "./auth.controller";
import { asyncWrap } from "../helpers";
import { postDb, userDb } from "../db";
import { TypedRequest } from "../types";

export const userByPostId = (
  reqExp: Request,
  res: Response,
  next: NextFunction,
  postId: string
) => {
  const req = reqExp as TypedRequest;
  req.user = userDb.findUserByPostId(postId);
  next();
};

//Create
export const createFileAndPost = asyncWrap(async (reqExp, res, next) => {
  const req = reqExp as TypedRequestAuth<{ userId: string }>;

  const { userId } = req.auth;

  const form = formidable({
    uploadDir: "uploads",
    keepExtensions: true,
    multiples: true,
  });

  const fileIdArr = new Array();

  form.parse(req, async (err, fields, files) => {
    if (!Array.isArray(fields.title)) {
      const title = fields.title;
      if (!Array.isArray(fields.text)) {
        const text = fields.text;
        if (!Array.isArray(fields.theme)) {
          const theme = fields.theme;
          if (!Array.isArray(fields.city)) {
            const city = fields.city;

            if (Array.isArray(files.picture)) {
              for (var i = 0; i < files.picture.length; i++) {
                const originalfilename = files.picture?.[i].originalFilename;
                const newfilename = files.picture?.[i].newFilename;
                const filepath = files.picture?.[i].filepath;

                const filesRes = await postDb.createFilesRow(
                  originalfilename,
                  newfilename,
                  filepath
                );

                fileIdArr.push(filesRes);
              }
            } else if (!Array.isArray(files.picture)) {
              const originalfilename = files.picture.originalFilename;
              const newfilename = files.picture.newFilename;
              const filepath = files.picture.filepath;

              const filesRes = await postDb.createFilesRow(
                originalfilename,
                newfilename,
                filepath
              );

              fileIdArr.push(filesRes);
            } // file or one or more

            const postRes = await postDb.createPostRow({
              title,
              text,
              theme,
              city,
              date: Date.now(),
              counts: 0,
              user: userId,
              file: fileIdArr,
            });

            return res.json(postRes);
          }
        }
      }
    }
  });
});

//Read
export const getAllPost = asyncWrap(async (req, res) => {
  const posts = await postDb.getPosts();

  return res.json(posts);
});

export const getFiles = asyncWrap(async (req, res) => {
  const { postId } = req.params;
  const files = await postDb.getFilesByPostId(postId);

  return res.json(files);
});

//Update
export const addCounts = asyncWrap(async (req, res) => {
  const { postId } = req.params;
  const { counts } = req.body as {
    counts: number;
  };
  const updateCounts = await postDb.addOneCount(postId, counts);

  return res.json(updateCounts);
});

export const updatePost = asyncWrap(async (reqExp, res) => {
  const req = reqExp as TypedRequestAuth<{ userId: string }>;

  const userId = req.auth.userId;
  const { postId } = req.params;

  const form = formidable({
    uploadDir: "uploads",
    keepExtensions: true,
    multiples: true,
  });

  const fileIdArr = new Array();

  const oldSet = new Set();
  const newSet = new Set();

  form.parse(req, async (err, fields, files) => {
    if (!Array.isArray(fields.title)) {
      const title = fields.title;
      if (!Array.isArray(fields.text)) {
        const text = fields.text;
        if (!Array.isArray(fields.theme)) {
          const theme = fields.theme;
          if (!Array.isArray(fields.city)) {
            const city = fields.city;
            if (!Array.isArray(fields.change)) {
              const change = fields.change;

              const oldFiles = await postDb.getFilesByPostId(postId);
              if (!(oldFiles === undefined)) {
                for (var i = 0; (i = oldFiles.length); i++) {
                  const oldFileName = postDb.getOriginalFileName(oldFiles[i]);
                  if (!(oldFileName === undefined)) {
                    oldSet.add(oldFileName);
                  }
                }
              }

              if (Array.isArray(files.picture)) {
                for (var i = 0; i < files.picture.length; i++) {
                  const newFileName = files.picture?.[i].originalFilename;
                  if (!(newFileName === undefined)) {
                    newSet.add(newFileName);
                  }
                }
              }

              const deleteFiles = new Array();
              const addFiles = new Array();

              oldSet.forEach((oldName) => {
                newSet.forEach((newName) => {
                  if (!(oldName === newName)) {
                    deleteFiles.push(oldName);
                    addFiles.push(newName);
                  }
                });
              });

              for (var i = 0; i < deleteFiles.length; i++) {
                const originalfilename = deleteFiles[i];
                const delRes = await postDb.deleteFileByName(originalfilename);
              }

              if (Array.isArray(files.picture)) {
                for (var i = 0; i < files.picture.length; i++) {
                  const originalfilename = files.picture?.[i].originalFilename;
                  const newfilename = files.picture?.[i].newFilename;
                  const filepath = files.picture?.[i].filepath;
                  for (var i = 0; i < addFiles.length; i++) {
                    const original = addFiles[i];
                    if (original === originalfilename) {
                      const addRes = await postDb.createFilesRow(
                        originalfilename,
                        newfilename,
                        filepath
                      );

                      fileIdArr.push(addRes);
                    }
                  }
                }
              }

              const updateRes = await postDb.updatedFileId(postId);
              const fileId = fileIdArr.concat(updateRes);

              const postRes = await postDb.updatePostRow(
                {
                  title,
                  text,
                  theme,
                  city,
                  date: Date.now(),
                  user: userId,
                  file: fileId,
                },
                postId
              );
              console.log("plzplzplzpllzplzlpzplzzplz", postRes);
              return res.json(postRes);
            }
          }
        }
      }
    }
  });
});

//Delete
export const deleteOnePost = asyncWrap(async (req, res) => {
  const { postId } = req.params;
  // console.log(postId);
  const deleteCount = await postDb.deletePost(postId);
  const deleteFileId = await postDb.getFilesByPostId(postId);

  if (!(deleteFileId === undefined)) {
    for (var i = 0; i < deleteFileId.length; i++) {
      const deleteId = deleteFileId[i];
      const deleteFile = await postDb.deleteFile(deleteId);
    }
  }

  return res.json(deleteCount);
});
