import React, { useState } from "react";
import { Link } from "react-router-dom";

function PasswordUpdate() {
  const [password, setPassword] = useState("");
  const [confirm, setConfirm] = useState("");

  const handleSubmit = () => {

    if (password && confirm){
    
      if (password==confirm) {
        alert("비밀번호가 일치합니다.");
      } else {
        alert("비밀번호가 다릅니다.");
      }
    }else {
      alert("비밀번호가 입력되지 않았습니다.")
    }

  };

  return (
    <form onSubmit={handleSubmit}>
      <input
        className="border border-black"
        type="password"
        name="password"
        value={password}
        onChange={(e) => setPassword(e.target.value )}
      />
      <input
        className="border border-black"
        type="confirm"
        name="confirm"
        value={confirm}
        onChange={(e) => setConfirm(e.target.value )}
      />
      <button type="submit">비밀번호 확인</button>
    </form>
  );
}



export default function Signup () {
  return(

  <div className="gap-5">
    
      <div className="flex flex-col gap-2">
        <div className="p-12 w-1/2 h-1/2 md:w-40 md:h-1/6 bg-red-400 place-self-center rounded-2xl">
          <Link to="/">Travel Report</Link>
        </div>
          
        <div className="place-self-center py-3 border-b border-white ">
          <input className="placeholder:text-slate-300
            bg-white border border-slate-500 rounded-2xl
            py-2 pl-9 pr-3 
            focus:border-black" placeholder="ID " type="text"/>
        </div>
          
        <div className="place-self-center py-3 border-b border-white ">
          <input className="placeholder:text-slate-300
            bg-white border border-slate-500 rounded-2xl
            py-2 pl-9 pr-3 
            focus:border-black
            " name="firstPassword"placeholder="비밀번호" type="text"/>
        </div>
        <div className="place-self-center py-3 border-b border-white ">
          <input className="placeholder:text-slate-300
            bg-white border border-slate-500 rounded-2xl
            py-2 pl-9 pr-3 
            focus:border-black"placeholder="비밀번호 확인" type="text"/>
        </div>
        <div className="showText place-self-center">
        <PasswordUpdate />
        </div>
        <div className="place-self-center py-3 border-b border-white 
          ">
          <input className="placeholder:text-slate-300
            bg-white border border-slate-500 rounded-2xl
            py-2 pl-9 pr-3 
            focus:border-black
            " placeholder="Id" type="text" name="Id"/>
        </div>
        <button className="place-self-center py-3 border-b border-white 
            ">
              회원가입 버튼
        </button>
            
      </div> 
    
    
  </div>
  )
}
//출처 : //https://www.daleseo.com/react-forms/