import { model, Schema, Types } from "mongoose";

export interface MainimgType {
  theme: string;
  city: string;
  title: string;
  pic?: Types.ObjectId;
}

const MainimgSchema = new Schema<MainimgType>({
  theme: {
    type: String,
  },
  city: {
    type: String,
  },
  title: {
    type: String,
    required: true,
  },
  pic: { type: Schema.Types.ObjectId, ref: "Avatar" },
});

export default model<MainimgType>("Mainimg", MainimgSchema);
