import { ObjectId } from "mongoose";
import { Avatar, IAvatar, Mainimg, MainimgType } from "../models";

export const createMainimg = async (mainimg: MainimgType, pic: IAvatar) => {
  const newPic = await Avatar.create({
    originalfilename: pic.originalfilename,
    newfilename: pic.newfilename,
    pictureauth: pic.picturepath,
  });

  const newMainimg = await Mainimg.create({
    theme: mainimg.theme,
    city: mainimg.city,
    pic: newPic._id,
    title: mainimg.title,
  });
  return newMainimg;
};

export const getMainimg = async () => {
  const img = await Mainimg.find({}).populate("pic");

  return img;
};

export const deleteOneMainimg = async (_id: string) => {
  const res = await Mainimg.deleteOne({ _id: _id });
  return res;
};
