import { Files } from "formidable";

export interface IUser {
  email?: string;
  isLoggedIn: boolean;
  _id?: string;
}

export interface LoginUser {
  email: string;
  password: string;
}

export interface PostType {
  title: string;
  text: string;
  theme: string;
  city: string;
  date: string | number;
  counts: number;
  _id: string;
  user: string;
}

export interface SignupUser {
  email: string;
  name: string;
  password: string;
}

export interface Profile {
  _id: string;
  email: string;
  avatar: {
    originalfilename: string;
    newfilename: string;
    picturepath: string;
    nickname: string;
  };
}

export interface MainimgType {
  _id: string;
  theme: string;
  city: string;
  title: string;
  pic: {
    originalfilename: string;
    newfilename: string;
  };
}
