import React, { MouseEventHandler } from "react";

type CityProps = {
  handleClick: MouseEventHandler;
};

export default function Citylist({ handleClick }: CityProps) {
  return (
    <div className="overflow-auto w-full flex flex-row md:flex-col md:mr-24 bg-sky-100">
      <div className="text-start px-5 py-2 bg-white shrink-0">도시</div>
      <button
        id={"Seoul"}
        onClick={handleClick}
        className="text-start  px-5 py-2 hover:underline shrink-0"
      >
        서울
      </button>
      <button
        id={"Busan"}
        onClick={handleClick}
        className="text-start px-5 py-2 hover:underline shrink-0"
      >
        부산
      </button>
      <button
        id={"Incheon"}
        onClick={handleClick}
        className="text-start px-5 py-2 hover:underline shrink-0"
      >
        인천
      </button>
      <button
        id={"Daegoo"}
        onClick={handleClick}
        className="text-start px-5 py-2 hover:underline shrink-0"
      >
        대구
      </button>
      <button
        id={"Gwangjoo"}
        onClick={handleClick}
        className="text-start px-5 py-2 hover:underline shrink-0"
      >
        광주
      </button>
      <button
        id={"Daejeon"}
        onClick={handleClick}
        className="text-start px-5 py-2 hover:underline shrink-0"
      >
        대전
      </button>
      <button
        id={"Woolsan"}
        onClick={handleClick}
        className="text-start px-5 py-2 hover:underline shrink-0"
      >
        울산
      </button>
      <button
        id={"Sejong"}
        onClick={handleClick}
        className="text-start px-5 py-2 hover:underline shrink-0"
      >
        세종
      </button>
      <button
        id={"Dokdo"}
        onClick={handleClick}
        className="text-start px-5 py-2 hover:underline shrink-0"
      >
        독도
      </button>
      <button
        id={"Jeju"}
        onClick={handleClick}
        className="text-start px-5 py-2 hover:underline shrink-0"
      >
        제주
      </button>
      {/* citylist */}
    </div>
    // Citylist Page
  );
}
