import { model, Schema } from "mongoose";

export interface PostType extends PostingType {
  date?: string;
  counts: number;
  id?: string;
}

export interface PostingType {
  title: string;
  text?: string;
  theme: string;
  city: string;
  username: string;
}

const schema = new Schema<PostType>({
  id: { type: String },
  title: { type: String },
  date: { type: Date },
  text: { type: String },
  counts: { type: Number },
  theme: { type: String },
  city: { type: String },
  username: { type: String },
});

export default model<PostType>("Post", schema);
