import React, { useEffect, MouseEvent, useState, useRef } from "react";
import { Outlet, useSearchParams } from "react-router-dom";
import Theme from "./theme";
import Citylist from "../Pages/citylist";
import { getPicure } from "../Pages/pic";
import { PaginationLeft, PaginationRight } from "../Pages/picpagination";

const initSearchParams = { theme: "", city: "" };

export default function Body() {
  let limit = 15;
  const [searchParams, setSearchParams] = useSearchParams(initSearchParams);
  const [page, setPage] = useState(1);
  const offset1 = (page - 1) * limit;
  const offset2 = page * limit;
  const offset3 = (page + 1) * limit;
  const renderRef = useRef() as React.MutableRefObject<HTMLDivElement>
  let getPics = getPicure();

  useEffect(() => {
    console.log(searchParams.get("theme"), searchParams.get("city"));
    setSearchParams(searchParams)
  }, []);

  useEffect(() => {
    renderRef.current.style.transition = "all 0.5s ease-in-out"
    renderRef.current.style.transform = `translateX(-${page - 1}00%)`
  }, [page]);

  const themeHandleClick = (event: MouseEvent<HTMLButtonElement>) => {
    console.log(`theme id= ${event.currentTarget.id}`);
    setSearchParams({
      ...Object.fromEntries(searchParams),
      theme: event.currentTarget.id,
    });
  };

  const cityHandleClick = (event: MouseEvent<HTMLButtonElement>) => {
    console.log(`city id= ${event.currentTarget.id}`);
    setSearchParams({
      ...Object.fromEntries(searchParams),
      city: event.currentTarget.id,
    });
  };

  let themechange = searchParams.get("theme");
  let citylistchange = searchParams.get("city");

  const Idpics = getPics.filter((p) => {
    return (
      (p.themeid == themechange && p.cityid == citylistchange) ||
      (p.themeid == themechange && citylistchange == "") ||
      (themechange == "" && p.cityid == citylistchange) ||
      (themechange == "" && citylistchange == "")
    );
  });

  // const pre = () => {
  //   setSelected(selected - 1)
  // };

  // const next = () => {
  //   setSelected(selected + 1)
  // };

  return (
    <div className="flex flex-col px-1 py-1">
      <Theme handleClick={themeHandleClick} />
      <div className="flex flex-col md:flex-row py-10 ">
        <div className="w-50">
          <Citylist handleClick={cityHandleClick} />
        </div>
        <div className="flex flex-col  overflow-hidden">
          <PaginationLeft total={Idpics.length} page={page} setPage={setPage} />
          <PaginationRight total={Idpics.length} page={page} setPage={setPage} />
          <div className=" md:mr-10 md:basis-4/5  flex flex-row relative w-full " ref={renderRef}>
            {/* <div className=" md:mr-10 md:basis-4/5  flex flex-row  transition duration-500 relative w-full " style={{"transform" : "translate(-"+(page-1)*100+"%)"}}>   */}
            <div className="min-w-full">
              <div className="inline-grid grid-cols-5">
                {Idpics.slice(offset1, offset1 + limit).map((pic, index: number) => (

                  <div
                    className="m-1 shrink-0 bg-gray-200 rounded shadow-md"
                    key={index}>
                    <img
                      src={pic.url}
                      className="w-full h-10 md:h-20 object-center"
                    />
                    <p className="text-center text-xs">{pic.name}</p>
                  </div>

                ))}
              </div>
            </div>
            <div className="min-w-full">
              <div className="inline-grid grid-rows-3 grid-cols-5">
                {Idpics.slice(offset2, offset2 + limit).map((pic, index: number) => (

                  <div
                    className="m-1 shrink-0 bg-gray-200 rounded shadow-md"
                    key={index}
                  >
                    <img
                      src={pic.url}
                      className="w-full h-10 md:h-20 object-center"
                    />
                    <p className="text-center text-xs">{pic.name}</p>
                  </div>

                ))}
              </div>
            </div>
            <div className="min-w-full">
              <div className="inline-grid grid-rows-3 grid-cols-5">
                {Idpics.slice(offset3, offset3 + limit).map((pic, index: number) => (

                  <div
                    className="m-1 shrink-0 bg-gray-200 rounded shadow-md"
                    key={index}
                  >
                    <img
                      src={pic.url}
                      className="w-full h-10 md:h-20 object-center"
                    />
                    <p className="text-center text-xs">{pic.name}</p>
                  </div>

                ))}
              </div>
            </div>
          </div>
        </div>
      </div>

      <Outlet />
    </div>
    // Body Page
  );
}

