import React from "react";

type num = {
    total: number,
    page: number, 
    setPage : Function
}
    
export function PaginationLeft ({total, page,setPage} : num) {
    const numPages = Math.ceil(total / 15);

    const left =()=>{
        setPage(page - 1)
    };

    return (
        <div>
            <button onClick={left} disabled={page === 1}>
                &lt;{page}</button>

            {/* {Array(numPages)
                .fill(1)
                .map((_, i) => (
                    <button key={i + 1} onClick={() => setPage(i + 1)}>
                        {i + 1}
                    </button>
                ))} */}
        </div>
    );
};
export function PaginationRight ({total, page,setPage} : num) {
    const numPages = Math.ceil(total / 15);

    const right =()=>{
        setPage(page + 1)
    };

    return (
        <div>
            <button onClick={right} disabled={page === numPages}>
                &gt;
            </button>
        </div>
    );
};
