import React, { useState } from "react";

export interface PostType {
    id: string;
    title: string;
    date: string;
    click: number;
}

type Props = {
    post: PostType;
}

export default function Post({ post }: Props) {
    const [count, setCount] = useState(0);

    return (
        <div className="flex flex-row h-16 divide-x-2 border-2 border-solid">
            <div className="basis-full">
                <button onClick={() => setCount(count + 1)}>{post.title}</button>
            </div> {/*<Link to>title</Link> */}
            <div className="basis-3/12">{post.date}</div>
            <div className="basis-2/12">{count}</div>
        </div>
    );
}