import React, { MouseEventHandler } from "react";

type ThemeProps = {
  handleClick: MouseEventHandler;
};

export default function Theme({ handleClick }: ThemeProps) {
  return (
    <div className="overflow-x-auto flex rounded md:justify-center">
      <button id={"surfing"} onClick={handleClick} className="shrink-0 px-5 hover:text-sky-300">
        서핑
      </button>
      <button id={"activity"} onClick={handleClick} className="shrink-0 px-5 hover:text-sky-300">
        액티비티
      </button>
      <button id={"camping"} onClick={handleClick} className="shrink-0 px-5 hover:text-sky-300 ">
        캠핑
      </button>
      <button id={"sking"} onClick={handleClick} className="shrink-0 px-5 hover:text-sky-300">
        스키
      </button>
      <button id={"boat"} onClick={handleClick} className="shrink-0 px-5 hover:text-sky-300">
        보트
      </button>
      <button id={"desert"} onClick={handleClick} className="shrink-0 px-5 hover:text-sky-300">
        사막
      </button>
      <button id={"golf"} onClick={handleClick} className="shrink-0 px-5 hover:text-sky-300">
        골프
      </button>
      <button id={"cave"} onClick={handleClick} className="shrink-0 px-5 hover:text-sky-300">
        동굴
      </button>
      <button id={"history"} onClick={handleClick} className="shrink-0 px-5 hover:text-sky-300">
        문화재
      </button>
      <button id={"zoo"} onClick={handleClick} className="shrink-0 px-5 hover:text-sky-300">
        동물원
      </button>
      <button id={"cycling"} onClick={handleClick} className="shrink-0 px-5 hover:text-sky-300">
        사이클링
      </button>
    </div>
  );
}
