import axios from "axios";
import { MainimgType } from "../types";
import baseUrl from "./baseUrl";

export const mainimg = async (mainimg: MainimgType) => {
    const { data } = await axios.post(`${baseUrl}/mainimg`, mainimg);
    return data;
};

export const delmainimg = async (_id : string) => {
    const { data } = await axios.delete(`${baseUrl}/mainimg/${_id}`);
    return data;
};

export const getmainimg = async () => {
    const { data } = await axios.get(`${baseUrl}/mainimg`);
    return data;
};

export const updating = async (img: MainimgType) => {
    const { data } = await axios.put(`${baseUrl}/mainimg/${img._id}`, img);
    return data;
  };