import express from "express";
import { mainimgCtrl, authCtrl } from "../controllers";

const router = express.Router();

router
  .route("/")
  .get(authCtrl.requireLogin, mainimgCtrl.getMainimg)
  .post(authCtrl.requireLogin, mainimgCtrl.createMainimg)
  
router
  .route("/:imgId")
  .delete(authCtrl.requireLogin, mainimgCtrl.deleteMainimg)
  .put(authCtrl.requireLogin, mainimgCtrl.updateMainimg);


export default router;
