import React, {useState} from "react";

function range(start:number, end:number) {
    return (new Array(end - start + 1)).fill(undefined).map((_, i) => i + start);
}

export default function BoardPage() {
    const ords = range(0,4); //[0,1,2,3,4];
    const [count, setCount] = useState(0);

    const fakes = [['Seoul', '2022-06-30', '0'], ['Jeju', '2022-9-10', '1'], ['Busan', '2022-9-22', '2'], ['Daegu', '2022-10-1', '3'], ['Incheon', '2022-12-12','4'],];
    
    return (
        <div className="flex flex-col items-center">
            <div className="flex flex-col items-center mt-6">
                <div>
                    `Travel Report's Board`
                </div>
                <div>
                    `여행지 후기를 남겨주세요!`
                </div>
            </div>

            <div className="flex flex-col w-10/12 mt-16 ">
                <div>
                    <div className="flex flex-row divide-x-2 border-2 border-solid bg-gray-500 border-y-2 h-10 ">
                                <div className="basis-1/12">No.</div>
                                <div className="basis-full">Title</div>
                                <div className="basis-3/12">Date</div>
                                <div className="basis-2/12">Clicks</div>
                    </div>
                    <div>
                        {ords.map((ord, index) => (
                            <div key={index} className="flex flex-row h-16 divide-x-2 border-2 border-solid ">
                                <div className="basis-1/12 bg-gray-100">{ord + 1}</div>
                                <div className="basis-full"><button onClick={() => setCount(count + 1)}>{fakes[ord][0]}</button></div> {/*<Link to>title</Link> */}
                                <div className="basis-3/12">{fakes[ord][1]}</div>
                                <div className="basis-2/12">{count}</div>
                            </div>
                        ))}
                    </div>
                </div>
            </div>
        </div>
    );
}