import React, { FormEvent, useEffect, useState } from "react";
import { mainimgApi } from "../apis";
import { catchErrors } from "../helpers";
import { MainimgType } from "../types";


export default function Admin() {

    const [getimgs, setGetimgs] = useState<MainimgType[]>([]);
    
    async function imgsData() {
        const imgs = await mainimgApi.getmainimg();
        console.log("ㅑㅡㅎ", imgs)
        setGetimgs(imgs)
    };
    
    useEffect(() => {
        imgsData();
    }, []);

    const [addimg, setAddimg] = useState<MainimgType>({
        theme: "",
        city: "",
        url: "",
        title: "",
    });
    const [loading, setLoading] = useState(false);
    const [error, setError] = useState("");
    const [success, setSuccess] = useState(false);

    function handleSelectChange(event: React.ChangeEvent<HTMLSelectElement>) {
        const { name, value } = event.currentTarget;
        setAddimg({ ...addimg, [name]: value });
    }
    function handleInputeChange(event: React.ChangeEvent<HTMLInputElement>) {
        const { name, value } = event.currentTarget;
        setAddimg({ ...addimg, [name]: value });
    }

    console.log("asdafsdfs", getimgs)
    async function handleSubmit(event: FormEvent) {
        event.preventDefault();
        try {
            setError("");
            console.log("img data", addimg);
            setLoading(true);
            const res = await mainimgApi.mainimg(addimg);
            console.log("서버연결됬나요", res);
            setSuccess(true);
            setError("");
        } catch (error) {
            console.log("에러발생");
            catchErrors(error, setError);
        } finally {
            setLoading(false);
        }
    }

    if (success) {
        alert("img 추가되었습니다");

    }
    
    return (
        <div>
            <form
                onSubmit={handleSubmit}>
                <div className="flex justify-center gap-3">
                    <select
                        name="city"
                        id="Questions"
                        className="border border-3 border-black w-20 my-5"
                        defaultValue="질문종류"
                        onChange={handleSelectChange}
                    >
                        <option value="질문종류">도시</option>
                        <option value="Seoul">서울</option>
                        <option value="Busan">부산</option>
                        <option value="Incheon">인천</option>
                        <option value="Daegoo">대구</option>
                        <option value="Kwangjoo">광주</option>
                        <option value="Daejeon">대전</option>
                        <option value="Woolsan">울산</option>
                        <option value="Sejong">세종</option>
                        <option value="Dokdo">독도</option>
                        <option value="Jeju">제주</option>
                    </select>
                    <select
                        name="theme"
                        id="Questions"
                        className="border border-3 border-black w-20 my-5"
                        defaultValue="질문종류"
                        onChange={handleSelectChange}
                    >
                        <option value="질문종류">테마</option>
                        <option value="cycling">사이클링</option>
                        <option value="surfing">서핑</option>
                        <option value="activity">액티비티</option>
                        <option value="camping">캠핑</option>
                        <option value="sking">스키</option>
                        <option value="boat">보트</option>
                        <option value="desert">사막</option>
                        <option value="golf">골프</option>
                        <option value="cave">동굴</option>
                        <option value="history">문화재</option>
                        <option value="zoo">동물원</option>
                        <option value="cycling">사이클링</option>
                    </select>
                    <div>
                        <p>url</p>
                        <input name="url" className="border-2 border-sky-500"
                            onChange={handleInputeChange} />
                        {/* type="file"/> */}
                    </div>
                    <div>
                        <p>title</p>
                        <input name="title" className="border-2 border-sky-500"
                            onChange={handleInputeChange} />
                    </div>
                    <div className="my-5 ">
                        <button className="border-2 border-gray-500 rounded">추가</button>
                    </div>
                </div>
            </form>
            {getimgs.map((img, index: number) => (
                <div key = {index}>
                    
                <img src={img.url} />
                </div>)
            )}

        </div>
    );
};
