import React, { MouseEvent, useEffect, useState } from "react";
import { useLocation, useNavigate, Link, Outlet } from "react-router-dom";
import { catchErrors } from "../helpers";
import { postApi } from "../apis";
import { PostType } from "../types";

export interface PostState {
  state: PostType;
}

export function IntoPost() {
  const location = useLocation() as PostState;
  const post = location.state;
  const navigate = useNavigate();

  console.log("user info", post.user);

  const [loading, setLoading] = useState(false);
  const [error, setError] = useState("");
  const [addSuccess, setAddSuccess] = useState(false);
  const [delSuccess, setDelSuccess] = useState(false);

  const handleDeleteClick = async (event: MouseEvent<HTMLButtonElement>) => {
    try {
      if (confirm("삭제하시겠습니까?") == true) {
        const postId = event.currentTarget.id;
        const res = await postApi.deletePost(postId);
        navigate("/board", { replace: true });
        console.log("delete post", res);
      } else {
        return false;
      }
    } catch (error) {
      console.log("에러발생");
      catchErrors(error, setError);
    }
  };

  return (
    <div className="flex flex-col">
      <div className="flex h-8 gap-x-1 place-content-end place-items-center">
        <button
          id={post._id}
          onClick={handleDeleteClick}
          className=" whitespace-nowrap flex border-2 border-sky-100 place-self-center h-6 w-8 text-xs text-center transition delay-150 bg-white-400 hover:-translate-y-1 hover:scale-110 hover:bg-red-300 duration-300"
        >
          삭제
        </button>
        <Link to="/edit" state={post}>
          <button className="whitespace-nowrap flex border-2 border-sky-100 place-self-center h-6 w-8 text-xs transition delay-150 bg-white-400 hover:-translate-y-1 hover:scale-110 hover:bg-sky-300 duration-300">
            수정
          </button>
        </Link>
      </div>
      <div className="flex h-10 border-t-2 border-sky-500 items-center font-semibold">
        {post.title}
      </div>

      <div className="flex h-10 items-center border-t-2 border-sky-200 md:flex-row justify-between bg-slate-50 text-sm">
        <div className="flex whitespace-nowrap pr-5 ">
          작성자: {post.user.name}
        </div>

        <div className="flex divide-x divide-slate-300 ">
          <div className="flex basis-1/2 whitespace-nowrap px-2">
            작성일 : {post.date.slice(0, 10)}
          </div>
          <div className="flex whitespace-nowrap px-2"> {post.city}</div>
          <div className="flex whitespace-nowrap px-2"> {post.theme}</div>
          <div className="flex whitespace-nowrap px-2">
            조회수 : {post.counts}
          </div>
        </div>
      </div>

      <div className="flex border-t-2 border-sky-200 h-44 p-2 overflow-auto mb-5 ">
        {post.file?.map((file, i) => (
          <img
            key={i}
            src={"http://localhost:3000/images/" + file.newfilename}
            width={200}
            height={200}
          />
        ))}
      </div>
      <div className="border-b-2 border-sky-500 h-44 mb-10">{post.text}</div>
    </div>
  );
}
