import React from "react";



function range(start:number, end:number) {
    return (new Array(end - start + 1)).fill(undefined).map((_, i) => i + start);
}

export default function BoardPage() {
    const imgs = range(0,7); //[1,2,3,4,5,6,7]
    return (
        <div className="flex flex-col items-center">
            <div className="flex flex-col items-center mt-6">
                <div>
                    `Travel Report's Board`
                </div>
                <div>
                    `여행지 후기를 남겨주세요!`
                </div>
            </div>
            <div className="flex flex-col w-10/12 mt-16 ">
                <div>
                    <div className="bg-gray-500 border-y-2 h-10">
                    Board
                    </div>
                    <div>
                        {imgs.map(img => (
                            <div className="flex flex-row h-16 divide-x-2 border-2 border-solid ">
                                <div className="basis-1/12 bg-gray-100">{img}</div>
                                <div className="basis-full">title</div>
                                <div className="basis-3/12">date</div>
                                <div className="basis-2/12">like</div>
                            </div>

                        ))}
                    </div>
                </div>
            </div>
        </div>
    );
}