import express from "express";
import { postCtrl, authCtrl, fileInfoCtrl } from "../controllers";

const router = express.Router();

router.route("/").post(authCtrl.requireLogin, postCtrl.createFileAndPost);
router.route("/").get(postCtrl.getAllPost);

router.route("/files/:postId").get(authCtrl.requireLogin, postCtrl.getFiles);

// router.param("postId", postCtrl.userByPostId);
router
  .route("/:postId")
  .post(authCtrl.requireLogin, postCtrl.addCounts)
  .delete(authCtrl.requireLogin, postCtrl.deleteOnePost) // +authenticate
  .put(authCtrl.requireLogin, postCtrl.updateOnePost);

router.param("postId", postCtrl.userByPostId);
export default router;
