import React, { MouseEventHandler, useEffect, useState } from "react";

type ThemeProps = {
  handleClick: MouseEventHandler;
};

export default function Theme({ handleClick }: ThemeProps) {
  const [active, setActive] = useState(0);

  const onactive = "whitespace-nowrap px-5 text-lime-500 ";
  const offactive = "whitespace-nowrap px-5 ";

  const clickActive = (a: number) => {
    setActive(a);
  };

  return (
    <div className=" overflow-x-auto flex rounded py-2 md:py-4 md:pl-3 shadow-lg divide-x-2 bg-white">
      <div onClick={() => clickActive(1)} className="px-0 md:px-2">
        <button
          id={"surfing"}
          onClick={handleClick}
          className={active === 1 ? onactive : offactive}
        >
          서핑
        </button>
      </div>
      <div onClick={() => clickActive(2)} className="px-0 md:px-2">
        <button
          id={"activity"}
          onClick={handleClick}
          className={active === 2 ? onactive : offactive}
        >
          액티비티
        </button>
      </div>
      <div onClick={() => clickActive(3)} className="px-0 md:px-2">
        <button
          id={"camping"}
          onClick={handleClick}
          className={active === 3 ? onactive : offactive}
        >
          캠핑
        </button>
      </div>
      <div onClick={() => clickActive(4)} className="px-0 md:px-2">
        <button
          id={"skiing"}
          onClick={handleClick}
          className={active === 4 ? onactive : offactive}
        >
          스키
        </button>
      </div>
      <div onClick={() => clickActive(5)} className="px-0 md:px-2">
        <button
          id={"boat"}
          onClick={handleClick}
          className={active === 5 ? onactive : offactive}
        >
          보트
        </button>
      </div>
      <div onClick={() => clickActive(6)} className="px-0 md:px-2">
        <button
          id={"desert"}
          onClick={handleClick}
          className={active === 6 ? onactive : offactive}
        >
          사막
        </button>
      </div>
      <div onClick={() => clickActive(7)} className="px-0 md:px-2">
        <button
          id={"golf"}
          onClick={handleClick}
          className={active === 7 ? onactive : offactive}
        >
          골프
        </button>
      </div>
      <div onClick={() => clickActive(8)} className="px-0 md:px-2">
        <button
          id={"cave"}
          onClick={handleClick}
          className={active === 8 ? onactive : offactive}
        >
          동굴
        </button>
      </div>
      <div onClick={() => clickActive(9)} className="px-0 md:px-2">
        <button
          id={"history"}
          onClick={handleClick}
          className={active === 9 ? onactive : offactive}
        >
          문화재
        </button>
      </div>
      <div onClick={() => clickActive(10)} className="px-0 md:px-2">
        <button
          id={"zoo"}
          onClick={handleClick}
          className={active === 10 ? onactive : offactive}
        >
          동물원
        </button>
      </div>
      <div onClick={() => clickActive(11)} className="px-0 md:px-2">
        <button
          id={"cycling"}
          onClick={handleClick}
          className={active === 11 ? onactive : offactive}
        >
          사이클링
        </button>
      </div>
    </div>
  );
}
