import React, { useEffect, MouseEvent } from "react";
import { BrowserRouter, Route, Routes, Link, Outlet, useSearchParams } from "react-router-dom";
import Theme from "./theme";
import getUrl from "../url"

const initSearchParams = { "theme": "1", "city": "1" }
export default function Body() {
    const [searchParams, setSearchParams] = useSearchParams(initSearchParams)

    useEffect(() => {
        console.log(searchParams.get('theme'), searchParams.get('city'))
        setSearchParams(searchParams)
    }, [])

    const handleClick = (event: MouseEvent<HTMLButtonElement>) => {
        console.log(`theme id= ${event.currentTarget.id}`)
    }

    let url = getUrl();
    return (

        <div className="flex flex-col px-5 py-5">
            <Theme handleClick={handleClick} />
            <div className="flex flex-col md:flex-row  px-5 py-40 ">
                <div className="flex flex-row justify-evenly md:flex-col md:basis-1/5 bg-gray-400 rounded ">
                    <button>01</button>
                    <button>02</button>
                    <button>03</button>
                    <button>04</button>
                    <button>06</button>
                    <button>07</button>
                    <button>05</button>
                    <button>08</button>
                    <button>09</button>
                    <button>10</button>
                    {/* citylist */}
                </div>
                <div className="flex md:basis-4/5 grid grid-rows-3 grid-cols-5 outline">
                    {url.map(url => (
                        <div className="flex justify-items-center" key={url.url}>{url.url}</div>
                    ))}
                    {/* pic */}
                </div>
            </div>
            <Outlet />
        </div>
        // Body Page
    );
};
