import axios from "axios";
import baseUrl from "./baseUrl";

export const profile = async () => {
  const { data } = await axios.get(`${baseUrl}/profile`);
  return data;
};

export const profileUpload = async (formdata: FormData) => {
  const { data } = await axios.post(`${baseUrl}/profile`, formdata);
  return data;
};

export const deleteUser = async () => {
  const success = await axios.delete(`${baseUrl}/profile`);
  return success;
};
