import React, { MouseEventHandler, useState } from "react";

type CityProps = {
  handleClick: MouseEventHandler;
};

export default function Citylist({ handleClick }: CityProps) {
  const [active, setActive] = useState(0);

  const onactive =
    "text-start  px-5 py-2 whitespace-nowrap w-full border-b-4 md:border-b-0 md:border-r-4 border-lime-500";
  const offactive = "text-start px-5 py-2 whitespace-nowrap w-full  ";

  const clickActive = (a: number) => {
    setActive(a);
  };

  return (
    <div className="overflow-auto w-full md:w-36 bg-white flex flex-row md:flex-col md:mr-24 shadow-lg">
      <div onClick={() => clickActive(1)}>
        <button
          id={"Seoul"}
          onClick={handleClick}
          className={active === 1 ? onactive : offactive}
        >
          서울
        </button>
      </div>
      <div onClick={() => clickActive(2)}>
        <button
          id={"Busan"}
          onClick={handleClick}
          className={active === 2 ? onactive : offactive}
        >
          부산
        </button>
      </div>
      <div onClick={() => clickActive(3)}>
        <button
          id={"Incheon"}
          onClick={handleClick}
          className={active === 3 ? onactive : offactive}
        >
          인천
        </button>
      </div>
      <div onClick={() => clickActive(4)}>
        <button
          id={"Daegoo"}
          onClick={handleClick}
          className={active === 4 ? onactive : offactive}
        >
          대구
        </button>
      </div>
      <div onClick={() => clickActive(5)}>
        <button
          id={"Gwangjoo"}
          onClick={handleClick}
          className={active === 5 ? onactive : offactive}
        >
          광주
        </button>
      </div>
      <div onClick={() => clickActive(6)}>
        <button
          id={"Daejeon"}
          onClick={handleClick}
          className={active === 6 ? onactive : offactive}
        >
          대전
        </button>
      </div>
      <div onClick={() => clickActive(7)}>
        <button
          id={"Woolsan"}
          onClick={handleClick}
          className={active === 7 ? onactive : offactive}
        >
          울산
        </button>
      </div>
      <div onClick={() => clickActive(8)}>
        <button
          id={"Sejong"}
          onClick={handleClick}
          className={active === 8 ? onactive : offactive}
        >
          세종
        </button>
      </div>
      <div onClick={() => clickActive(9)}>
        <button
          id={"Dokdo"}
          onClick={handleClick}
          className={active === 9 ? onactive : offactive}
        >
          독도
        </button>
      </div>
      <div onClick={() => clickActive(10)}>
        <button
          id={"Jeju"}
          onClick={handleClick}
          className={active === 10 ? onactive : offactive}
        >
          제주
        </button>
      </div>
    </div>
    // Citylist Page
  );
}
