import React, { FormEvent, useEffect, useState } from "react";
import { Link, Navigate } from "react-router-dom";
import { authApi } from "../apis";
import { catchErrors } from "../helpers";
import { SpinnerIcon } from "../icons";
import { SignupUser } from "../types";

export default function Signup() {
  const [user, setUser] = useState<SignupUser & { password2: string }>({
    name: "",
    email: "",
    password: "",
    password2: "",
  });

  const [loading, setLoading] = useState(false);
  const [error, setError] = useState("");
  const [disabled, setDisabled] = useState(false);
  const [success, setSuccess] = useState(false);

  useEffect(() => {
    setDisabled(!(user.name && user.email && user.password && user.password2));
  }, [user]);

  function handleChange(event: React.ChangeEvent<HTMLInputElement>) {
    const { name, value } = event.currentTarget;
    setUser({ ...user, [name]: value });
  }

  async function handleSubmit(event: FormEvent) {
    event.preventDefault();
    try {
      setError("");
      console.log("checkPassword:", passwordMatch());
      console.log("user data", user);
      if (passwordMatch()) {
        const { password2, ...sUser } = user;
        setLoading(true);
        const res = await authApi.signup(sUser);
        console.log("서버연결됬나요", res);
        console.log("회원가입");
        setSuccess(true);
        setError("");
      }
    } catch (error) {
      console.log("에러발생");
      catchErrors(error, setError);
    } finally {
      setLoading(false);
    }
  }

  function passwordMatch() {
    if (user.password !== user.password2) {
      // alert();
      setError("비밀번호가 일치하지않습니다");
      console.log("password fail");
      return false;
    } else {
      console.log("password match");
      return true;
    }
  }

  if (success) {
    alert("회원가입 되었습니다");
    return <Navigate to={"/login"} replace />;
  }

  return (
    <div>
      <div className="flex flex-col shadow-lg bg-white rounded">
        <div className="grid place-items-center ml-2 mt-8 text-center text-2xl ">
          <Link to="/">회원가입</Link>
        </div>

        <form onSubmit={handleSubmit} className="flex flex-col  mt-16 gap-y-4">
          <div className="flex flex-col px-8 sm:px-32 pb-5">
            <div className="border-0 border-y-2 border-black ">
              <div className="h-16 flex ">
                <div className="whitespace-nowrap grid place-items-center w-32 lg:basis-1/5 shrink-0 border-0 border-r-2">
                  이름
                </div>
                <div className="flex items-center mx-5 ">
                  <input
                    className="h-10 w-4/5 lg:w-60 border-2 focus:border-black"
                    type="text"
                    name="name"
                    onChange={handleChange}
                  />
                </div>
              </div>
              <div className="h-16 flex border-0 border-t-2">
                <div className="whitespace-nowrap grid place-items-center w-32 lg:basis-1/5 shrink-0 border-0 border-r-2">
                  이메일
                </div>
                <div className="flex items-center mx-5">
                  <input
                    className=" w-4/5 h-10 lg:w-60  border-2 focus:border-black"
                    type="email"
                    name="email"
                    onChange={handleChange}
                  />
                </div>
              </div>
              <div className="h-16 flex border-0 border-t-2">
                <div className="whitespace-nowrap grid place-items-center w-32 lg:basis-1/5 shrink-0 border-0 border-r-2">
                  비밀번호
                </div>
                <div className="flex items-center  mx-5">
                  <input
                    className="w-4/5 h-10  lg:w-60  border-2 focus:border-black"
                    type="password"
                    name="password"
                    onChange={handleChange}
                  />
                </div>
              </div>

              <div className="h-16 flex border-0 border-t-2">
                <div className="whitespace-nowrap grid place-items-center w-32 lg:basis-1/5 shrink-0 border-0 border-r-2">
                  비밀번호 확인
                </div>

                <div className="flex items-center mx-5">
                  <input
                    className="w-4/5 h-10 lg:w-60  border-2 focus:border-black"
                    type="password"
                    name="password2"
                    onChange={handleChange}
                  />
                </div>
              </div>
            </div>
            {error && (
              <div className="text-red-500 text-sm">
                <p>{error}</p>
              </div>
            )}

            <button
              disabled={disabled}
              className="border-b border-white mt-5 h-12 w-52 text-white text-lg bg-amber-400 place-self-center"
            >
              {loading && (
                <SpinnerIcon className="animate-spin h-5 w-5 mr-1 text-slate" />
              )}
              회원가입
            </button>
          </div>
        </form>
      </div>
      <div className="bg-lime-100 h-36" />
    </div>
  );
}
