import { model, Schema } from "mongoose";

export interface PostingType {
  title: string;
  text?: string;
  theme: string;
  city: string;
  username?: string;
  date?: string;
  counts?: number;
}

const postingSchema = new Schema<PostingType>({
  title: {
    type: String,
    required: true,
  },
  text: {
    type: String,
    required: true,
  },
  theme: {
    type: String,
  },
  city: {
    type: String,
  },
  username: {
    type: String,
    // username: travelreport.users.findOne({id: cookie.token._id(Schema.Tpyes.ObjectId)}).name,
  },
  date: {
    type: Date,
    default: Date.now,
  },
  counts: {
    type: Number,
  },
  date: {
    type: Date,
    dafault: Date.now,
  },
  counts: 0,
});

export default model<PostingType>("Posting", postingSchema);
