import { NextFunction, Request, Response } from "express";
import isLength from "validator/lib/isLength";
import equals from "validator/lib/equals";
import { requireLogin } from "./auth.controller";
import { asyncWrap } from "../helpers";
import { postDb } from "../db";

export const posting = asyncWrap(async (req, res) => {
  const { title, text, theme, city, username, date, counts } = req.body;

  console.log("body", req.body);

  // 0) 로그인 했는지 확인 requireLogin

  // 1) title 빈 문자열인지 확인
  if (!isLength(title ?? "", { min: 1 })) {
    return res.status(422).send("제목을 한 글자 이상 입력해주세요");
  }

  // 2) body 빈 문자열인지 확인
  if (!isLength(text ?? "", { min: 1 })) {
    return res.status(422).send("제목을 한 글자 이상 입력해주세요");
  }

  // 3) theme dropdown default-value "테마"일 경우 에러
  if (equals(theme, "질문종류")) {
    return res.status(422).send("테마를 입력해 주세요");
  }

  // 4) city dropdown default-value "도시"일 경우 에러
  if (equals(city, "질문종류")) {
    return res.status(422).send("도시를 선택해 주세요");
  }

  // 5) username ref: cookie.token._id -> collection users, "User"->  name

  const newPosting = await postDb.createPosting({
    title,
    text,
    theme,
    city,
    username,
    date,
    counts,
  });
  return res.json(newPosting);
});
