import { model, Schema, Types } from "mongoose";
import { PostingType } from "./posting.model";

export interface PostType extends PostingType {
  date?: string;
  counts: number;
  id?: string;
}

const postSchema = new Schema<PostType>({
  title: { type: String },
  theme: { type: String },
  city: { type: String },
  username: { type: String },
  date: { type: String },
  counts: { type: Number },
});

export default model<PostType>("Post", postSchema);
