import React, { MouseEventHandler } from "react";

type ThemeProps = {
  handleClick: MouseEventHandler;
};

export default function Theme({ handleClick }: ThemeProps) {
  return (
    <div className="flex overflow-x-auto bg-emerald-400 md:px-52 ">
      <button
        id={"surfing"}
        onClick={handleClick}
        className="hover:underline underline-offset-4 decoration-white px-5 shrink-0"
      >
        서핑
      </button>
      <button
        id={"activity"}
        onClick={handleClick}
        className="hover:underline underline-offset-4 decoration-white px-5 shrink-0"
      >
        액티비티
      </button>
      <button
        id={"camping"}
        onClick={handleClick}
        className="hover:underline underline-offset-4 decoration-white px-5 shrink-0"
      >
        캠핑
      </button>
      <button
        id={"sking"}
        onClick={handleClick}
        className="hover:underline underline-offset-4 decoration-white px-5 shrink-0"
      >
        스키
      </button>
      <button
        id={"boat"}
        onClick={handleClick}
        className="hover:underline underline-offset-4 decoration-white px-5 shrink-0"
      >
        보트
      </button>
      <button
        id={"desert"}
        onClick={handleClick}
        className="hover:underline underline-offset-4 decoration-white px-5 shrink-0"
      >
        사막
      </button>
      <button
        id={"golf"}
        onClick={handleClick}
        className="hover:underline underline-offset-4 decoration-white  px-5 shrink-0"
      >
        골프
      </button>
      <button
        id={"cave"}
        onClick={handleClick}
        className="hover:underline underline-offset-4 decoration-white px-5 shrink-0"
      >
        동굴
      </button>
      <button
        id={"history"}
        onClick={handleClick}
        className="hover:underline underline-offset-4 decoration-white px-5 shrink-0"
      >
        문화재
      </button>
      <button
        id={"zoo"}
        onClick={handleClick}
        className="hover:underline underline-offset-4 decoration-white px-5 shrink-0"
      >
        동물원
      </button>
      <button
        id={"cycling"}
        onClick={handleClick}
        className="hover:underline underline-offset-4 decoration-white px-5 shrink-0"
      >
        사이클링
      </button>
    </div>
  );
}
