import React, { MouseEventHandler, useEffect, MouseEvent } from "react";
import { BrowserRouter, Route, Routes, Link, Outlet, useSearchParams } from "react-router-dom";
import Theme from "./theme";
import getUrl from "../url"

// const initSearchParams = ["theme", "city"]
const initSearchParams = { "theme": "1", "city": "1" }
export default function Body() {
    const [searchParams, setSearchParams] = useSearchParams(initSearchParams)

    useEffect(() => {
        console.log(searchParams.get('theme'), searchParams.get('city'))
        setSearchParams(searchParams)
    }, [])

    const handleClick = (event: MouseEvent<HTMLButtonElement>) => {
        console.log(`theme id= ${event.currentTarget.id}`)
    }

    // const imgs = [1, 2, 3, 4, 5]
    let url=getUrl();
    return (
        <div>
            <div className="flex flex-col px-5 py-5">
                <Theme handleClick={handleClick} />
                <div className="flex flex-col md:flex-row  px-5 py-40 ">
                    <div className="flex flex-row md:flex-col md:basis-1/5 bg-gray-400 rounded ">
                        <div>01</div>
                        <div>02</div>
                        <div>03</div>
                        <div>04</div>
                        <div>05</div>
                        <div>06</div>
                        <div>07</div>
                        <div>08</div>
                        <div>09</div>
                        <div>10</div>
                        {/* citylist */}
                    </div>
                    <div className="flex md:basis-4/5 grid grid-rows-3 grid-cols-5 outline">
                        {url.map(url => (
                            <div className="flex justify-items-center" key={url.url}>{url.url}</div>
                        ))}
                        {/* pic */}
                    </div>
                </div>

                <Outlet />
            </div>

        </div> // Body Page
    );
};
