import React, { useEffect, MouseEvent, useState } from "react";
import { Outlet, useSearchParams } from "react-router-dom";
import Theme from "./theme";
import Citylist from "../Pages/citylist";
import { getPicure } from "../Pages/pic";
import { PaginationLeft ,PaginationRight} from "../Pages/picpagination";

const initSearchParams = { theme: "", city: "" };

export default function Body() {
  let limit = 15;
  const [searchParams, setSearchParams] = useSearchParams(initSearchParams);
  const [page, setPage] = useState(1);
  const offset = (page - 1) * limit;
  const [selected, setSelected] = useState(1);
  let getPics = getPicure();

  useEffect(() => {
    console.log(searchParams.get("theme"), searchParams.get("city"));
    // setSearchParams(searchParams)
  }, []);

  const themeHandleClick = (event: MouseEvent<HTMLButtonElement>) => {
    console.log(`theme id= ${event.currentTarget.id}`);
    setSearchParams({
      ...Object.fromEntries(searchParams),
      theme: event.currentTarget.id,
    });
  };

  const cityHandleClick = (event: MouseEvent<HTMLButtonElement>) => {
    console.log(`city id= ${event.currentTarget.id}`);
    setSearchParams({
      ...Object.fromEntries(searchParams),
      city: event.currentTarget.id,
    });
  };

  let themechange = searchParams.get("theme");
  let citylistchange = searchParams.get("city");

  const Idpics = getPics.filter((p) => {
    return (
      (p.themeid == themechange && p.cityid == citylistchange) ||
      (p.themeid == themechange && citylistchange == "") ||
      (themechange == "" && p.cityid == citylistchange) ||
      (themechange == "" && citylistchange == "")
    );
  });

  const pre = () =>{
    setSelected(selected -1)
    };

  const next = () =>{
    setSelected(selected + 1)
    };

  return (
    <div className="flex flex-col px-1 py-1">
      <Theme handleClick={themeHandleClick} />
      <div className="flex flex-col md:flex-row py-10 ">
        <div className="w-50">
          <Citylist handleClick={cityHandleClick} />
        </div>
        <div className="flex flex-col">
          <div>
            <button onClick={pre} disabled={selected === 1}>&lt;{selected}</button>
            <button onClick={next} disabled={selected === 3}>&gt;</button>
          </div>
          <div >
            <div className=" md:mr-10 md:basis-4/5 overflow-hidden">
              <div className=" flex flex-row transition duration-500 relative" style={{"transform": 'translate(-' + (selected-1)*100 + '%)'}}>
                <img className = "border-2"src="https://t1.daumcdn.net/cfile/tistory/9947E0365C31C1BF0E"/>
                <img className = "border-2"src="https://t1.daumcdn.net/cfile/tistory/9947E0365C31C1BF0E"/>
                <img className = "border-2"src="https://t1.daumcdn.net/cfile/tistory/9947E0365C31C1BF0E"/>
              </div>
            </div>
          </div>
        </div>
      </div>
      
      <Outlet />
    </div>
    // Body Page
  );
}
{/* <div className=" md:mr-10 md:basis-4/5 grid grid-rows-3 grid-cols-5"></div> */}
 {/* {Idpics.slice(offset, offset + limit).map((pic, index: number) => (
            <div
            className="m-1 shrink-0 bg-gray-200 rounded overflow-hidden shadow-md"
            key={index} 
            >
            <img
                src={pic.url}
                className="w-full h-10 md:h-20 object-center"
                />
                <p className="text-center text-xs">{pic.name}</p>
                </div>
              ))}  */}
              {/* <PaginationLeft total={Idpics.length} page={page} setPage={setPage} /> */}
            {/* <PaginationRight total={Idpics.length} page={page} setPage={setPage} /> */}