import { model, Schema } from "mongoose";

export interface PostType {
    id: string;
    title: string;
    date: Date;
    body : string;
    counts?: number;
    theme: string;
    city: string;
  }
  
const schema = new Schema<PostType>({
  id : {type: String},
  title : { type: String },
  date : {type: Date},
  body : {type : String},
  counts : {type: Number},
  theme : {type: String},
  city : {type: String},
  
});

export default model<PostType>("Post", schema);
