import bcrypt from "bcryptjs";
import { Files } from "formidable";
import { ObjectId } from "mongoose";
import { IUser, Post, User } from "../models";

export const createUser = async (user: IUser) => {
  // 비밀번호 암호화
  const hash = await bcrypt.hash(user.password, 10);
  const newUser = await User.create({
    email: user.email,
    password: hash,
    name: user.name,
  });
  return newUser;
};

export const findUserByEmail = async (
  email: string,
  includePassword: boolean = false
) => {
  let user;
  if (includePassword) {
    user = await User.findOne({ email }).select("+password");
  } else {
    user = await User.findOne({ email });
  }
  return user;
};

export const findUserByPostId = async (postId: string) => {
  const post = await Post.findOne({ _id: postId }).populate("user");
  return post?.user;
};

export const getUsers = async () => {
  const users = await User.find({});
  return users;
};

export const isUser = async (email: string) => {
  const user = await User.findOne({ email });
  if (user) {
    return true;
  } else {
    return false;
  }
};

export const getProfile = async (userId: string) => {
  const profile = await User.findById(userId);
  return profile; //이름 수정
};

export const postPicture = (
  userId: ObjectId,
  originalfilename: string | null,
  newfilename: string,
  picturepath: string
) => {
  User.findByIdAndUpdate(
    userId,
    {
      originalfilename: originalfilename,
      newfilename: newfilename,
      picturepath: picturepath,
    },
    function (err: any, docs: any) {
      if (err) {
        console.log(err);
      } else {
        console.log("Updated User : ", docs);
      }
    }
  );
};
