import React, { useState } from "react";
import { useLocation, useParams } from "react-router-dom";

interface PostState {
  state: {
    title: string;
    text: string;
    theme: string;
    city: string;
    date: string;
    counts: number;
    _id: string;
    user: string;
  };
}

export function IntoPost() {
  const location = useLocation() as PostState;
  const post = location.state;
  // console.log(post);

  return (
    <div>
      <div>
        <div className="flex flex-row">
          <div className="flex basis-3/4">제목: {post.title}</div>
          <div className="flex basis-1/4">작성자: nickname</div>
        </div>
        <div className="flex flex-row">
          <div className="flex basis-1/4">도시: {post.city}</div>
          <div className="flex basis-1/4">테마: {post.theme}</div>
          <div className="flex basis-1/4">작성일: {post.date}</div>
          <div className="flex basis-1/4">조회수: {post.counts}</div>
        </div>
      </div>
      <div>{post.text}</div>
    </div>
  );
}
