import React from "react";
import { BrowserRouter, Route, Routes, Link, Outlet } from "react-router-dom";
import "tailwindcss/tailwind.css";
import { IntoPost } from "./post/intopost";
import { Login, Signup } from "./auth";
import { Header, Body } from "./home";
import { Board } from "./board";
import Posting from "./post/posting";

export const App = () => {
  return (
    <BrowserRouter>
      <Routes>
        <Route path="login" element={<Login />} />
        <Route path="signup" element={<Signup />} />
        <Route path="/" element={<Header />}>
          <Route index element={<Body />} />
          <Route path="posting" element={<Posting />} />
          <Route path="board" element={<Board />} />
          <Route path="post/:postId" element={<IntoPost />} />
        </Route>
      </Routes>
    </BrowserRouter>
  );
};
