import axios from "axios";
import baseUrl from "./baseUrl";
import { PostType } from "../types";

export const posting = async (post: PostType) => {
  const { data } = await axios.post(`${baseUrl}/posts/`, post);

  return data;
};

export const getData = async () => {
  const { data } = await axios.get(`${baseUrl}/posts/`);
  return data;
};

export const addCounts = async (_id: string, counts: number) => {
  const { data } = await axios.post(`${baseUrl}/posts/${_id}`, {
    counts: counts + 1,
  });
  return data;
};

export const getPostByPostId = async (_id: string) => {
  const { data } = await axios.get(`${baseUrl}/posts/${_id}`);
  return data;
};
