import { userDb } from "../db";
import { asyncWrap } from "../helpers/asyncWrap";
import { Request } from "express";
import formidable, { Fields, Files } from "formidable";
import { ObjectId } from "mongoose";
import fs from "fs";

export interface TypedRequestAuth<T> extends Request {
  auth: T;
}

export const getUsers = asyncWrap(async (req, res) => {
  const users = await userDb.getUsers();
  return res.json(users);
});

export const createUser = asyncWrap(async (req, res) => {
  const user = req.body;
  console.log("user body", user);
  const newUser = await userDb.createUser(user);
  return res.json(newUser);
});

export const getProfile = asyncWrap(async (reqExp, res) => {
  const req = reqExp as TypedRequestAuth<{ userId: string }>; // 앞에서는 토큰으로써 사용하기 때문에 JwtPayload 를 사용하고 여기서는 verify 에서 토큰을 디코딩했기에 ObjectId 타입의 string으로 바뀌게 된다.

  const { userId } = req.auth;
  const profile = await userDb.getProfile(userId);
  res.json(profile);
});

export const postPicture = asyncWrap(async (reqExp, res) => {
  const req = reqExp as TypedRequestAuth<{ userId: ObjectId }>;
  const { userId } = req.auth;

  const form = formidable({
    uploadDir: "./src/upload",
    keepExtensions: true,
    multiples: false,
  });

  form.parse(req, (err, fields, files) => {
    if (!Array.isArray(files.picture)) {
      //파일 좁히기 중

      const originalfilename = files.picture.originalFilename;
      const newfilename = files.picture.newFilename;
      const picturepath = files.picture.filepath;
      userDb.postPicture(userId, originalfilename, newfilename, picturepath);
    }
  });
  res.json();
});
