import React, { useState, MouseEvent, MouseEventHandler } from "react";
import { PostType } from "./typesrc";

type Props = {
    post: PostType;
    handleClick: MouseEventHandler;
}

export default function Post({ handleClick, post }: Props) {

    return (
        <div className="flex flex-row h-16 divide-x-2 border-2 border-solid">
            <div className="basis-full">
                <button id={post.id} onClick={handleClick}>{post.title}</button>
            </div>
            <div className="basis-3/12">{post.date}</div>
            <div className="basis-2/12">{post.counts}</div>
        </div>
    );
}