import React, { useState, MouseEvent } from "react";
import { Link } from "react-router-dom";
import { PostType } from "../types";
import Post from "../post/post";

function range(start: number, end: number) {
  return new Array(end - start + 1).fill(undefined).map((_, i) => i + start);
}

interface Posts {
  posts: PostType[];
}

export const fakes = [
  {
    id: "a",
    title: "여행가고싶다...",
    date: "2022-06-30",
    counts: 0,
    theme: "surfing",
    city: "seoul",
  },
  {
    id: "b",
    title: "바다!바다!바다!",
    date: "2022-08-01",
    counts: 0,
    theme: "surfing",
    city: "seoul",
  },
  {
    id: "c",
    title: "Jeju-island",
    date: "2022-9-10",
    counts: 0,
    theme: "surfing",
    city: "seoul",
  },
  {
    id: "d",
    title: "마! 부싼 가봤나!",
    date: "2022-9-22",
    counts: 0,
    theme: "surfing",
    city: "seoul",
  },
  {
    id: "e",
    title: "Daegu",
    date: "2022-10-1",
    counts: 0,
    theme: "surfing",
    city: "seoul",
  },
  {
    id: "f",
    title: "강원도 감자는 맛있다.",
    date: "2022-12-12",
    counts: 0,
    theme: "surfing",
    city: "seoul",
  },
  {
    id: "g",
    title: "부산남자의 서울여행",
    date: "2022-12-25",
    counts: 0,
    theme: "surfing",
    city: "seoul",
  },
];

export default function BoardPage() {
  const [posts, setPosts] = useState<PostType[]>(fakes);

  const titleHandleClick = (event: MouseEvent<HTMLButtonElement>) => {
    const postId = event.currentTarget.id;
    const newposts = [...posts];
    newposts.forEach((post) => {
      if (post.id === postId) {
        post.counts = post.counts + 1;
        return;
      }
    });
    setPosts(newposts);
  };

  return (
    <div className="flex flex-col items-center">
      <div className="flex flex-col items-center mt-6">
        <div>`Travel Report's Board`</div>
        <div>`여행지 후기를 남겨주세요!`</div>
      </div>

      <div className="flex flex-col w-10/12 mt-16">
        <div className="flex justify-end">
          <div className="border-2 mb-2">
            <Link to="/posting">
              <button>글쓰기+</button>
            </Link>
          </div>{" "}
          {/* Link */}
        </div>
        <div className="sm:overflow-y-scroll">
          <div className="flex flex-row divide-x-2 border-2 border-solid bg-gray-500 border-y-2 h-10 ">
            <div className="basis-full">Title</div>
            <div className="basis-3/12">Date</div>
            <div className="basis-2/12">Clicks</div>
          </div>
          <div>
            {posts.map((post) => (
              <Post key={post.id} post={post} handleClick={titleHandleClick} />
            ))}
          </div>
        </div>
      </div>
    </div>
  );
}
